package org.amse.mm.myTest;

import junit.framework.TestCase;
import org.amse.mm.myVirtualBilliards.model.*;
import org.amse.mm.myVirtualBilliards.model.impl.*;


public class TestDynamic extends TestCase{
	public void test1(){
		Table table = new Table(0.0000001);
		IBall ball = table.addBall(10, 10, BallColor.BLACK);
		ball.setVelocity(10, 0);
		table.doMove(5);
		assertTrue(Math.abs(ball.getCoordinate().X - 60.0) < 0.01);
	}
	
	public void test3(){
		Table table = new Table(0.00001);
		IBall ball = table.addBall(10, 10, BallColor.BLACK); 
		ball.setVelocity(0, -10);
		table.doMove(0.5);
		assertTrue(Math.abs(ball.getCoordinate().Y - 5.0) < 0.01);	
	}
	
	public void test4(){
		Table table = new Table(0.0001);
		IBall ball = table.addBall(10, 10, BallColor.BLACK);
		ball.setVelocity(0, -10);
		table.doMove(2);
		assertTrue(Math.abs(ball.getCoordinate().Y - 10.0) < 0.01);	
	}

	public void test5(){
		Table table = new Table(0.0001);
		IBall ball = table.addBall(10, 10, BallColor.BLACK);
		ball.setVelocity(0, -10);
		table.doMove(30);
		assertTrue(Math.abs(ball.getCoordinate().Y - 210.0) < 0.5);	
	}

	
	public void test6(){
		Table table = new Table(0.0001);
		IBall ball = table.addBall(100, 100, BallColor.BLACK);
		ball.setVelocity(10, 10);
		table.doMove(20);
		assertTrue(Math.abs(ball.getCoordinate().Y - 200.0) < 1);	
	}
	
	public void test7(){
		Table table = new Table();
		IBall ball1 = table.addBall(100, 110, BallColor.BLACK);
		IBall ball2 = table.addBall(100, 10, BallColor.WHITE);
		ball1.setVelocity(0, 20);
		table.doMove(20);
		assertEquals(ball2.getCoordinate().Y, 10.0);	
	}

	public void test9(){
		Table table = new Table(0.0001);
		IBall ball1 = table.addBall(80, 50, BallColor.BLACK);
		ball1.setVelocity(10, -10);
		table.doMove(10);
		assertTrue(Math.abs(ball1.getCoordinate().Y - 50.0) < 1);	
	}

	public void test11(){
		Table table = new Table(0.001);
		IBall ball1 = table.addBall(50, 50, BallColor.BLACK);
		IBall ball2 = table.addBall(50, 100, BallColor.WHITE);
		IBall ball3 = table.addBall(50, 150, BallColor.BLUE);
		ball1.setVelocity(0, -10);
		table.doMove(18);
		assertTrue(Math.abs(ball3.getVelocity().VY - 10.0) < 1);	
	}

	public void test13(){
		Table table = new Table();
		IBall ball1 = table.addBall(50, 100, BallColor.BLACK);
		IBall ball2 = table.addBall(50, 150, BallColor.WHITE);
		ball1.setVelocity(0, 10);
		table.doMove(5.0);
		assertTrue(ball1.getVelocity().VY + ball1.getVelocity().VX == 0);	
	}
	
	public void test14(){
		Table table = new Table(); 
		IBall ball1  = table.addBall(50, 50, BallColor.WHITE);
		IBall ball2  = table.addBall(100, 100, BallColor.BLACK);
		ball1.setVelocity(2, 2);
		ball2.setVelocity(-8, -8);
		table.doMove(20);
		assertTrue(table.balls().size() == 1);
	}

	public void test16(){
		Table table = new Table();
		IBall ball = table.addBall(30, 125, BallColor.BLACK);
		ball.setVelocity(-10, 0);
		table.doMove(7);
		assertEquals(table.balls().size(), 0);
	}
	
	public void test17(){
		Table table = new Table();
		IBall ball = table.addBall(30, 125, BallColor.BLACK);
		ball.setVelocity(-5, 1);
		table.doMove(7);
		assertEquals(table.balls().size(), 1);
	}
	
	public void test18(){
		Table table = new Table(0.02);
		IBall ball = table.addBall(30, 125, BallColor.BLACK);
		ball.setVelocity(-3, 0);
		table.doMove(10);
		assertEquals(table.balls().size(), 1);
	}

	public void test19(){
		Table table = new Table(0.02);
		IBall ball1  = table.addBall(60, 100, BallColor.WHITE);
		IBall ball2  = table.addBall(50, 50, BallColor.BLACK);
		ball1.setVelocity(-0.2, -10 );
		table.doMove(20);
		assertEquals(table.balls().size(), 1);
	}
	
	public void test20(){
		Table table = new Table(0.02);
		IBall ball1  = table.addBall(90, 100, BallColor.WHITE);
		IBall ball2  = table.addBall(100, 50, BallColor.BLACK);
		ball1.setVelocity(0.2, -10 );
		table.doMove(20);
		assertEquals(table.balls().size(), 1);
	}
	
	public void test21(){
		Table table = new Table(0.02);
		IBall ball1  = table.addBall(90, 150, BallColor.WHITE);
		IBall ball2  = table.addBall(100, 200, BallColor.BLACK);
		ball1.setVelocity(0.2, 10 );
		table.doMove(20);
		assertEquals(table.balls().size(), 1);
	}
	
	public void test22(){
		Table table = new Table(0.02);
		IBall ball1  = table.addBall(60, 150, BallColor.WHITE);
		IBall ball2  = table.addBall(50, 200, BallColor.BLACK);
		ball1.setVelocity(-0.2, 10 );
		table.doMove(20);
		assertEquals(table.balls().size(), 1);
	}
	
	public void test23(){
		Table table = new Table(0.02);
		IBall ball1  = table.addBall(60, 168, BallColor.WHITE);
		IBall ball2  = table.addBall(50, 218, BallColor.BLACK);
		ball1.setVelocity(0.2, 10 );
		table.doMove(20);
		assertEquals(table.balls().size(), 1);
	}
	
	public void test24(){
		Table table = new Table(0.02);
		IBall ball1  = table.addBall(90, 168, BallColor.WHITE);
		IBall ball2  = table.addBall(100, 218, BallColor.BLACK);
		ball1.setVelocity(-0.2, 10 );
		table.doMove(20);
		assertEquals(table.balls().size(), 1);
	}
	
	public void test25(){
		Table table = new Table(0.02);
		IBall ball1  = table.addBall(60, 82, BallColor.WHITE);
		IBall ball2  = table.addBall(50, 32, BallColor.BLACK);
		ball1.setVelocity(0.2, -10 );
		table.doMove(20);
		assertEquals(table.balls().size(), 1);
	}
	
	public void test26(){
		Table table = new Table(0.02);
		IBall ball1  = table.addBall(90, 82, BallColor.WHITE);
		IBall ball2  = table.addBall(100, 32, BallColor.BLACK);
		ball1.setVelocity(-0.2, -10 );
		table.doMove(20);
		assertEquals(table.balls().size(), 1);
	}
	
	public void test27(){
		Table table = new Table(0.02);
		IBall ball1  = table.addBall(50, 210, BallColor.WHITE);
		IBall ball2  = table.addBall(100, 200, BallColor.BLACK);
		ball1.setVelocity(10, 0.2 );
		table.doMove(20);
		assertEquals(table.balls().size(), 1);
	}
	
	public void test28(){
		Table table = new Table(0.02);
		IBall ball1  = table.addBall(68, 210, BallColor.WHITE);
		IBall ball2  = table.addBall(118, 200, BallColor.BLACK);
		ball1.setVelocity(10, -0.2 );
		table.doMove(20);
		assertEquals(table.balls().size(), 1);
	}
	
	public void test29(){
		Table table = new Table(0.02);
		IBall ball1  = table.addBall(100, 210, BallColor.WHITE);
		IBall ball2  = table.addBall(50, 200, BallColor.BLACK);
		ball1.setVelocity(-10, 0.2 );
		table.doMove(20);
		assertEquals(table.balls().size(), 1);
	}
	
	public void test30(){
		Table table = new Table(0.02);
		IBall ball1  = table.addBall(82, 210, BallColor.WHITE);
		IBall ball2  = table.addBall(32, 200, BallColor.BLACK);
		ball1.setVelocity(-10, -0.2 );
		table.doMove(20);
		assertEquals(table.balls().size(), 1);
	}
	
	public void test31(){
		Table table = new Table(0.02);
		IBall ball1  = table.addBall(82, 60, BallColor.WHITE);
		IBall ball2  = table.addBall(32, 50, BallColor.BLACK);
		ball1.setVelocity(-10, 0.2 );
		table.doMove(20);
		assertEquals(table.balls().size(), 1);
	}
	
	public void test32(){
		Table table = new Table(0.02);
		IBall ball1  = table.addBall(100, 37, BallColor.WHITE);
		IBall ball2  = table.addBall(50, 47, BallColor.BLACK);
		ball1.setVelocity(-10, -0.2 );
		table.doMove(30);
		assertEquals(table.balls().size(), 0);
	}
	
	public void test33(){
		Table table = new Table(0.02);
		IBall ball1  = table.addBall(82, 40, BallColor.WHITE);
		IBall ball2  = table.addBall(32, 50, BallColor.BLACK);
		ball1.setVelocity(-10, 0.2 );
		table.doMove(20);
		assertEquals(table.balls().size(), 1);
	}
	
	public void test34(){
		Table table = new Table(0.02);
		IBall ball1  = table.addBall(68, 40, BallColor.WHITE);
		IBall ball2  = table.addBall(118, 50, BallColor.BLACK);
		ball1.setVelocity(10, 0.2 );
		table.doMove(20);
		assertEquals(table.balls().size(), 1);
	}
	
}
		